pro prep_c3, fit1, fit2, img_c3, hdr_c3, scl
img1 = LASCO_READFITS(fit1,hr1)
img2 = LASCO_READFITS(fit2,hr2)
diff = img2 - img1
img_c3 = bytscl(diff,max=80*scl,min=-20*scl)
img_tmp = reduce(img_c3,2,/average)


;rotate image North to up if roll angle is downward 
hdr = hr2
roll = hdr.crota2
if roll gt 170. then begin
h_pix = get_sun_center(hr2)
xcen = h_pix.xcen/2.
ycen = h_pix.ycen/2.
conv_img,img_tmp,img,512,512,xcen,ycen
hdr.crota2 = 180.-roll
hdr.crota1 = 180.-roll
endif else img = img_tmp


tv,img
img_c3 = img
hdr_c3 = hdr

print, 'C3 time: ', hdr_c3.date_obs+' '+hdr_c3.time_obs

;test
;exptv,diff,max=80*scl,min=-20*scl, /nobox

return
end
