; test scl range: 1, 10, 20, 80, 800, etc
pro prep_c2, fit1, fit2, img, hdr,scl
img1 = LASCO_READFITS(fit1,hr1)
img2 = LASCO_READFITS(fit2,hr2)
diff = img2 - img1
bmin = -1. & bmax = 1.

img_diff = bytscl(diff,max=bmax*scl,min=bmin*scl)
;img_diff = bytscl(diff,max=bmax*scl,min=bmin*1.)
img_tmp = reduce(img_diff,2,/average)
hdr = hr2

; rotate img N to up if roll angle is downward
roll = hdr.crota2
if roll gt 170. then begin
h_pix = get_sun_center(hr2)
xcen = h_pix.xcen/2.
ycen = h_pix.ycen/2.
conv_img,img_tmp,img,512,512,xcen,ycen
hdr.crota2 = 180.-roll
hdr.crota1 = 180.-roll
endif else img = img_tmp

tv,img

print,'C2 time: ', hdr.date_obs+' '+hdr.time_obs
return
end
